#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct set_label
{
    using yield_context = yplatform::yield_context<set_label>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    set_label(
        web_context_ptr web_ctx,
        stream_ptr stream,
        uid_t uid,
        const mid_vector& mids,
        const lid_vector& lids,
        bool mark)
        : web_ctx(web_ctx), stream(stream), uid(uid), mids(mids), lids(lids), mark(mark)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                if (mids.empty() || lids.empty())
                {
                    WEB_LOG_STREAM(stream, info) << "missing mids or lids";
                    resp = make_error_response(http_code::bad_request, "missing mids or lids");
                    yield break;
                }
                yield yplatform::find<xeno>("xeno")->set_messages_label(
                    uid, mids, tid_vector(), lids, mark, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                resp = make_ok_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    mid_vector mids;
    lid_vector lids;
    bool mark;
    response resp;
};

}

#include <yplatform/unyield.h>
