#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct update_label
{
    using yield_context = yplatform::yield_context<update_label>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    update_label(
        web_context_ptr web_ctx,
        stream_ptr stream,
        uid_t uid,
        const std::string& lid,
        const std::string& name,
        const std::string& color)
        : web_ctx(web_ctx), stream(stream), uid(uid), lid(lid), name(name), color(color)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                if (name.empty() && color.empty())
                {
                    WEB_LOG_STREAM(stream, info) << "empty name and color";
                    resp = make_error_response(http_code::bad_request, "empty name and color");
                    yield break;
                }
                yield yplatform::find<xeno>("xeno")->update_label(uid, lid, name, color, ctx);
                if (ec)
                {
                    if (ec == ::xeno::code::label_not_found)
                    {
                        WEB_LOG_STREAM(stream, info) << ec.message();
                        resp = make_error_response(http_code::bad_request, ec.message());
                    }
                    else
                    {
                        WEB_LOG_STREAM(stream, error) << ec.message();
                        resp = make_error_response(http_code::internal_server_error, ec.message());
                    }

                    yield break;
                }
                resp = make_ok_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    std::string lid;
    std::string name;
    std::string color;
    response resp;
};

}

#include <yplatform/unyield.h>
