#pragma once

#include <common/http.h>
#include <ymod_httpclient/cluster_client.h>

namespace xeno::web {

struct proxy_settings
{
    proxy_settings(const yplatform::ptree& conf)
    {
        http_reactor = conf.get<std::string>("http.reactor");
        http_settings.parse_ptree(conf.get_child("http"));

        mobile_api_port = conf.get<uint16_t>("mobile_api_port");
        mobile_api_use_ssl = conf.get<bool>("mobile_api_use_ssl", mobile_api_use_ssl);
        internal_api_port = conf.get<uint16_t>("internal_api_port");
        internal_api_use_ssl = conf.get<bool>("internal_api_use_ssl", internal_api_use_ssl);

        auto proxy_headers_cfg = conf.equal_range("proxy_response_headers");
        for (auto& [name, header] : boost::make_iterator_range(proxy_headers_cfg))
        {
            proxy_response_headers.insert(header.data());
        }

        auto remove_headers_cfg = conf.equal_range("remove_request_headers");
        for (auto& [name, header] : boost::make_iterator_range(remove_headers_cfg))
        {
            remove_request_headers.insert(header.data());
        }
    }

    uint16_t mobile_api_port = 0;
    bool mobile_api_use_ssl = false;
    uint16_t internal_api_port = 0;
    bool internal_api_use_ssl = false;
    std::set<std::string> proxy_response_headers;
    std::set<std::string> remove_request_headers;
    std::string http_reactor;
    yhttp::cluster_client::settings http_settings;
};

using proxy_settings_ptr = std::shared_ptr<proxy_settings>;

}
