#pragma once

#include <web/common.h>
#include <web/web_context.h>
#include <web/mobile/response.h>
#include <web/internal/response.h>
#include <web/run_on_node.h>

#include <ymod_mdb_sharder/types.h>
#include <yplatform/find.h>
#include <yplatform/coroutine.h>

namespace xeno::web {

template <typename ClientResponse, typename Method, api_type ApiType = api_type::mobile>
class proxy_to_owner
    : public std::enable_shared_from_this<proxy_to_owner<ClientResponse, Method, ApiType>>
{
    using yield_context = yplatform::yield_context<proxy_to_owner>;
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using method_ptr = std::shared_ptr<Method>;

public:
    template <typename... Args>
    proxy_to_owner(web_context_ptr web_ctx, stream_ptr stream, uid_t uid, Args&&... args)
        : web_ctx_(web_ctx)
        , stream_(stream)
        , uid_(uid)
        , method_(std::make_shared<Method>(web_ctx_, stream_, uid, std::forward<Args>(args)...))
    {
        APPEND_UID_TO_LOG_PREFIX(stream_, uid_);
    }

    void operator()(yield_context)
    {
        run_on_owner<ClientResponse>(
            uid_, stream_, ApiType, web_ctx_, [method = method_] { yplatform::spawn(method); });
    }

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    uid_t uid_;
    method_ptr method_;
};

namespace internal {

template <typename Method>
using proxy_to_owner = web::proxy_to_owner<internal::response, Method, api_type::internal>;

}

}
