#pragma once

#include <web/sendbernar/responses.h>
#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::sendbernar::methods {

struct save
{
    using yield_context = yplatform::yield_context<save>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    save(web_context_ptr web_ctx, stream_ptr stream, uid_t uid, const fid_t& fid, mid_t old_mid)
        : web_ctx(web_ctx), stream(stream), uid(uid), fid(fid), old_mid(old_mid)
    {
    }

    void operator()(yield_context ctx, error ec = error())
    {
        try
        {
            reenter(ctx)
            {
                yield yplatform::find<xeno>("xeno")->save_draft(
                    uid,
                    fid,
                    std::string(
                        stream->request()->raw_body.begin(), stream->request()->raw_body.end()),
                    ctx);

                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                if (old_mid)
                {
                    yield yplatform::find<xeno>("xeno")->delete_messages(
                        uid, { old_mid }, {}, true, ctx);
                    if (ec)
                    {
                        WEB_LOG_STREAM(stream, error) << ec.message();
                        // response ok even if error
                    }
                }
                resp = make_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    void operator()(yield_context ctx, error ec, mid_t mid)
    {
        this->mid = mid;
        (*this)(ctx, ec);
    }

    response make_response()
    {
        json::value content;
        content["mid"] = mid;
        return make_ok_response(content);
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    fid_t fid;
    mid_t old_mid;
    mid_t mid = 0;
    response resp;
};

}

#include <yplatform/unyield.h>
