#pragma once

#include <yplatform/coroutine.h>
#include <boost/asio/coroutine.hpp>
#include <type_traits>

namespace xeno::web {

template <typename Coroutine, typename... Args>
typename std::enable_if<std::is_base_of<boost::asio::coroutine, Coroutine>::value>::type spawn(
    Args&&... args)
{
    Coroutine(std::forward<Args>(args)...)();
}

template <typename Coroutine, typename... Args>
typename std::enable_if<!std::is_base_of<boost::asio::coroutine, Coroutine>::value>::type spawn(
    Args&&... args)
{
    auto coro = std::make_shared<Coroutine>(std::forward<Args>(args)...);
    yplatform::spawn(coro);
}

}
