#pragma once

#include <common/types.h>
#include <xeno/sync_phase.h>

namespace xeno {

class iteration_stat
{
public:
    uint32_t store_message_attempts = 0;
    uint32_t store_message_errors = 0;
    std::map<sync_phase::sync_phase_t, time_traits::duration> phase_durations;
    bool downloaded_range_updated = false;

    void count_phase_switch(sync_phase::sync_phase_t new_phase)
    {
        finish_phase();
        current_phase = new_phase;
    }

    void finish_phase()
    {
        auto now = time_traits::clock::now();
        if (current_phase)
        {
            phase_durations[*current_phase] = now - phase_change_time;
            current_phase.reset();
        }
        phase_change_time = now;
    }

private:
    time_traits::time_point phase_change_time = time_traits::clock::now();
    std::optional<sync_phase::sync_phase_t> current_phase;
};

using iteration_stat_ptr = std::shared_ptr<iteration_stat>;

}
