#pragma once

namespace xeno {

template <typename Operation, typename Handler, typename... Args>
typename std::enable_if<std::is_base_of<boost::asio::coroutine, Operation>::value>::type spawn(
    Handler&& h,
    Args&&... args)
{

    Operation op(std::forward<Args>(args)...);
    op(std::forward<Handler>(h));
}

template <typename Operation, typename Handler, typename... Args>
typename std::enable_if<!std::is_base_of<boost::asio::coroutine, Operation>::value>::type spawn(
    Handler&& h,
    Args&&... args)
{

    auto coro_ptr = std::make_shared<Operation>(std::forward<Args>(args)...);
    yplatform::spawn(coro_ptr, std::forward<Handler>(h));
}

}
