#pragma once

#include <common/errors.h>
#include <mailbox/common.h>
#include <xeno/operations/environment.h>

#include <yplatform/log.h>
#include <yplatform/yield.h>

#include <memory>

namespace xeno {

struct check_timestamps_op
{
    using yield_ctx = yplatform::yield_context<check_timestamps_op>;

    template <typename Env>
    void operator()(
        yield_ctx ctx,
        Env&& env,
        error ec = {},
        mailbox::message_vector_ptr messages = nullptr)
    {
        try
        {
            reenter(ctx)
            {
                to_check = env.cache_mailbox->get_paths_to_check_timestamps();

                for (ipath = to_check->begin(); ipath != to_check->end(); ++ipath)
                {
                    ENV_LOG(env, info) << "getting first message info from external mailbox: "
                                       << ipath->first.to_string();
                    yield env.ext_mailbox->get_messages_info_by_num(
                        ipath->first, 1, 1, wrap(env, ctx, uninterruptible));
                    if (ec)
                    {
                        yield break;
                    }

                    if (!messages || messages->empty())
                    {
                        continue;
                    }

                    ext_msg = messages->at(0);

                    ENV_LOG(env, info)
                        << "getting last message info from local mailbox: " << ipath->second;
                    yield env.loc_mailbox->get_messages_info_top(
                        ipath->second, 1, wrap(env, ctx, uninterruptible));
                    if (ec)
                    {
                        yield break;
                    }

                    if (!messages || messages->empty())
                    {
                        continue;
                    }
                    loc_msg = messages->at(0);

                    if (ext_msg.date > loc_msg.date)
                    {
                        ec = code::need_clear_mailbox;
                        yield break;
                    }
                }
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "check timestamps op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (ctx.is_complete())
        {
            env(ec);
        }
    }

    mailbox::fid_t_opt fid;
    mailbox::message ext_msg;
    mailbox::message loc_msg;

    mailbox::path_fid_vector_ptr to_check;
    mailbox::path_fid_vector::iterator ipath;
};

}
#include <yplatform/unyield.h>
