#pragma once

#include <common/errors.h>
#include <mailbox/common.h>
#include <xeno/operations/environment.h>

#include <yplatform/log.h>

#include <boost/asio/yield.hpp>

namespace xeno {

struct clear_mailbox_op : public boost::asio::coroutine
{
    template <typename Env>
    void operator()(Env&& env, error ec = {}, mailbox::folder_vector_ptr folders = nullptr)
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "clearing local mailbox";
                yield env.loc_mailbox->clear(wrap(env, *this, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                ENV_LOG(env, info) << "reloading folder cache";
                yield env.loc_mailbox->get_folder_vector(wrap(env, *this, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                env.cache_mailbox->clear_folders();
                env.cache_mailbox->set_initial_folders(folders);
                env.cache_mailbox->update_folders_from_local(folders);

                ENV_LOG(env, info) << "restarting operatios";
                ec = code::need_restart;
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "clear mailbox op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }
};

}
#include <boost/asio/unyield.hpp>
