#pragma once

#include <common/errors.h>
#include <mailbox/common.h>
#include <xeno/operations/environment.h>

#include <yplatform/log.h>
#include <yplatform/yield.h>

namespace xeno {

struct create_external_folder_op
{
    using yield_ctx = yplatform::yield_context<create_external_folder_op>;

    create_external_folder_op(const mailbox::path_t& path) : path(path)
    {
    }

    template <typename Env>
    void operator()(
        yield_ctx ctx,
        Env&& env,
        error ec = {},
        mailbox::folder_vector_ptr folders = nullptr)
    {
        try
        {
            reenter(ctx)
            {
                ENV_LOG(env, info) << "creating folder in external mailbox: " << path.to_string();
                yield env.ext_mailbox->create_folder(path, wrap(env, ctx, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                ENV_LOG(env, info) << "reloading folder list fomr external mailbox";
                yield env.ext_mailbox->get_folder_vector(wrap(env, ctx, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                env.cache_mailbox->update_folders_from_external(folders);
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "create external folder op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (ctx.is_complete())
        {
            env(ec);
        }
    }
    mailbox::path_t path;
};

}
#include <yplatform/unyield.h>
