#pragma once

#include <common/errors.h>
#include <mailbox/common.h>
#include <xeno/operations/environment.h>

#include <yplatform/log.h>

#include <boost/asio/yield.hpp>

namespace xeno {

struct erase_security_locks_op : public boost::asio::coroutine
{
    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "erasing security locks in local mailbox";
                yield env.loc_mailbox->erase_security_locks(wrap(env, *this, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                env.cache_mailbox->erase_security_lock();
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "erase security locks op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }
};

}
#include <boost/asio/unyield.hpp>
