#pragma once

#include <common/errors.h>
#include <mailbox/common.h>
#include <xeno/operations/environment.h>

#include <yplatform/log.h>

#include <boost/asio/yield.hpp>

namespace xeno {

struct list_status_op : public boost::asio::coroutine
{
    template <typename Env>
    void operator()(Env&& env, error ec = {}, mailbox::folder_vector_ptr folders = nullptr)
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "getting folders from external mailbox";
                yield env.ext_mailbox->get_folder_vector(wrap(env, *this, uninterruptible));
                if (ec)
                {
                    yield break;
                }

                env.cache_mailbox->update_folders_from_external(folders);
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "list status op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }
};

}
#include <boost/asio/unyield.hpp>
