#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class delete_label_op : public boost::asio::coroutine
{
public:
    delete_label_op(const lid& lid) : lid_(lid)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "delete label started: lid=" << lid_;
                yield env.loc_mailbox->delete_label(lid_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "delete_label_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }

private:
    lid lid_;
};

}

#include <boost/asio/unyield.hpp>
