#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class get_or_create_label_by_symbol_op : public boost::asio::coroutine
{
public:
    get_or_create_label_by_symbol_op(const std::string& symbol, bool force_create)
        : symbol_(symbol), force_create_(force_create)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "get or create label by symbol=" << symbol_ << " started";
                yield env.loc_mailbox->get_or_create_label_by_symbol(
                    symbol_, force_create_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "get_or_create_label_by_symbol_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec, lid_);
        }
    }

    template <typename Env>
    void operator()(Env&& env, error ec, const lid& res)
    {
        lid_ = res;
        (*this)(std::forward<Env>(env), ec);
    }

private:
    std::string symbol_;
    bool force_create_;
    lid lid_;
};

}

#include <boost/asio/unyield.hpp>
