#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class get_or_create_label_op : public boost::asio::coroutine
{
public:
    get_or_create_label_op(
        const std::string& name,
        const std::string& color,
        const std::string& type,
        bool force_create)
        : name_(name), color_(color), type_(type), force_create_(force_create)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "get or create label started: name=" << name_
                                   << ", color=" << color_ << " type=" << type_;
                yield env.loc_mailbox->get_or_create_label(
                    name_, color_, type_, force_create_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "get_or_create_label_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec, lid_);
        }
    }

    template <typename Env>
    void operator()(Env&& env, error ec, const lid& res)
    {
        lid_ = res;
        (*this)(std::forward<Env>(env), ec);
    }

private:
    std::string name_;
    std::string color_;
    std::string type_;
    bool force_create_;
    lid lid_;
};

}

#include <boost/asio/unyield.hpp>
