#pragma once

#include <common/errors.h>
#include <mailbox/data_types/folder.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

struct get_provider_op : public boost::asio::coroutine
{
    template <typename Env>
    void operator()(Env&& env, error ec = {}, const std::string& provider = std::string())
    {
        try
        {
            reenter(this)
            {
                yield env.ext_mailbox->get_provider(
                    env.cache_mailbox->account().imap_ep, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "get_provider_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec, provider);
        }
    }
};

}

#include <boost/asio/unyield.hpp>
