#pragma once

#include <xeno/operations/environment.h>
#include <xeno/operations/sync/invalidate_auth_data_op.h>

#include <yplatform/yield.h>

namespace xeno::user {

struct invalidate_user_auth_op : boost::asio::coroutine
{
    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(*this)
            {
                while (auth_data(env).size())
                {
                    yield spawn<invalidate_auth_data_op>(
                        wrap(env, *this, uninterruptible), auth_data(env).front());
                    if (ec) yield break;
                }
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "invalidate user auth op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }

    template <typename Env>
    auth_data_vector& auth_data(Env&& env)
    {
        return env.cache_mailbox->account().auth_data;
    }
};

}

#include <yplatform/unyield.h>
