#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class set_folder_symbol_op : public boost::asio::coroutine
{
public:
    set_folder_symbol_op(const fid_t& fid, const std::string& symbol) : fid_(fid), symbol_(symbol)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info)
                    << "set folder symbol started: fid=" << fid_ << " symbol=" << symbol_;
                yield env.loc_mailbox->set_folder_symbol(
                    fid_, symbol_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "set_folder_symbol_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }

private:
    fid_t fid_;
    std::string symbol_;
};

}

#include <boost/asio/unyield.hpp>
