#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class set_folders_order_op : public boost::asio::coroutine
{
public:
    set_folders_order_op(const fid_t& fid, const fid_t& prev_fid) : fid_(fid), prev_fid_(prev_fid)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info)
                    << "set folders orders started: fid=" << fid_ << " prev_fid=" << prev_fid_;
                yield env.loc_mailbox->set_folders_order(
                    fid_, prev_fid_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "set_folders_order_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }

private:
    fid_t fid_;
    fid_t prev_fid_;
};

}

#include <boost/asio/unyield.hpp>
