#pragma once

#include <common/errors.h>
#include <xeno/operations/environment.h>

#include <boost/asio/coroutine.hpp>
#include <boost/asio/yield.hpp>

namespace xeno::user {

class update_label_op : public boost::asio::coroutine
{
public:
    update_label_op(const lid& lid, const std::string& name, const std::string& color)
        : lid_(lid), name_(name), color_(color)
    {
    }

    template <typename Env>
    void operator()(Env&& env, error ec = {})
    {
        try
        {
            reenter(this)
            {
                ENV_LOG(env, info) << "update label started: lid=" << lid_ << " name=" << name_
                                   << " color=" << color_;
                yield env.loc_mailbox->update_label(
                    lid_, name_, color_, wrap(env, *this, uninterruptible));
            }
        }
        catch (const std::exception& e)
        {
            ENV_LOG(env, error) << "update_label_op exception: " << e.what();
            ec = code::operation_exception;
        }

        if (is_complete())
        {
            env(ec);
        }
    }

private:
    lid lid_;
    std::string name_;
    std::string color_;
};

}

#include <boost/asio/unyield.hpp>
