#pragma once

#include <vector>
#include <string>

namespace xeno {
namespace sync_phase {

enum sync_phase_t
{
    initial = 0,
    sync_folders,
    sync_newest,
    sync_oldest,
    sync_oldest_flags_and_deleted,
    redownload_messages,
    user_op,

    COUNT
};

}

inline const std::string& to_string(sync_phase::sync_phase_t phase)
{
    static constexpr std::initializer_list<const char*> names = { "initial",
                                                                  "sync_folders",
                                                                  "sync_newest",
                                                                  "sync_oldest",
                                                                  "sync_oldest_flags_and_deleted",
                                                                  "redownload_messages",
                                                                  "user_op" };
    static_assert(
        names.size() == sync_phase::COUNT, "sync phases count doesn't correspond with names count");
    static const std::vector<std::string> state_names(names.begin(), names.end());
    return state_names[phase];
}

}
