#pragma once

#include <common/http.h>
#include <common/types.h>
#include <mailbox/data_types/folder.h>
#include <mailbox/external/external_mailbox_settings.h>
#include <mailbox/local/settings.h>
#include <xiva/xiva_settings.h>

#include <yplatform/time_traits.h>
#include <memory>

namespace xeno {

using error_count_delay_map = std::map<uint32_t, time_traits::duration>;

struct background_sync_settings
{
    time_traits::duration auth_retry_interval;
    int auth_by_password_tries = 0;
    int auth_by_oauth_tries = 0;
};

struct turbo_sync_settings
{
    struct folder_settings
    {
        uint32_t count = 0;
        time_traits::duration timeout = time_traits::duration::max();
    };

    std::map<mailbox::folder::type_t, folder_settings> folders;
};

struct synchronization_settings
{
    uint32_t delete_messages_chunk_size = 0;
    uint32_t user_op_chunk_size = 0;
    uint32_t newest_count = 0;
    uint32_t oldest_count = 0;
    uint32_t oldest_cache_size = 0;
    uint32_t oldest_flags_and_deletions_chunk_size = 0;
    uint32_t newest_downloading_retries = 0;
    turbo_sync_settings turbo_sync;
    uint32_t redownload_messages_cache_size = 0;
    error_count_delay_map redownload_messages_delay_groups;
    uint64_t max_message_size = 0;
    xiva_settings_ptr xiva_settings;
    background_sync_settings background_sync;
    std::set<std::string> low_priority_providers;
};

using synchronization_settings_ptr = std::shared_ptr<const synchronization_settings>;

struct xeno_settings
{
    yplatform::time_traits::duration iteration_timeout;
    yplatform::time_traits::duration user_operation_timeout;
    yplatform::time_traits::duration cleanup_controllers_interval;
    yplatform::time_traits::duration load_account_retry_interval;
    yplatform::time_traits::duration max_delay_between_iteration_result_logs;
    bool background_access_tokens_loading = false;
    std::string attachments_url;

    mailbox::local::settings_ptr loc_mailbox_settings;
    mailbox::external::settings_ptr ext_mailbox_settings =
        std::make_shared<mailbox::external::settings>();
    synchronization_settings_ptr sync_settings;
    std::set<uid_t> forbidden_uids;
};

using xeno_settings_ptr = std::shared_ptr<xeno_settings>;

}
