#pragma once

#include "xiva_settings.h"

#include <common/http.h>
#include <mailbox/common.h>

#include <ymod_httpclient/cluster_client.h>
#include <memory>
#include <string>

namespace xeno {

inline void unsubscribe(
    uid_t uid,
    const std::string& uuid,
    context_ptr task_ctx,
    xiva_settings_ptr xiva_settings,
    const without_data_cb& cb)
{
    std::stringstream url, headers;
    headers << "Authorization: Xiva " << xiva_settings->token << "\r\n";
    url << "/v2/unsubscribe/app?service=mail"
        << "&user=" << uid << "&uuid=" << uuid;
    auto request = http::request_t::POST(url.str(), headers.str(), std::string());
    auto client = yplatform::find<yhttp::cluster_client>("xiva_client");
    client->async_run(
        task_ctx, std::move(request), [task_ctx, cb](error err, yhttp::response response) {
            try
            {
                if (err)
                {
                    YLOG(task_ctx->logger(), error) << "unsubscribe user error: " << err.message();
                }
                else if (response.status != 200)
                {
                    err = code::cannot_unsubscribe_user;
                    YLOG(task_ctx->logger(), error)
                        << "unsubscribe user bad status: " << response.status << " "
                        << response.reason;
                }
            }
            catch (const std::exception& e)
            {
                YLOG(task_ctx->logger(), error) << "unsubscribe user exception: " << e.what();
                err = code::cannot_unsubscribe_user;
            }
            cb(err);
        });
}

}
