#pragma once

#include <common/msgpack.h>

#include <boost/optional.hpp>
#include <map>
#include <string>

namespace xeno {

struct xiva_event
{
    // don't remove or modify items
    std::string uid;
    std::string suid;
    std::string service;
    std::string operation;
    std::string lcn;
    std::string session_key;
    std::map<std::string, std::string> data;
    std::string raw_data;

    MSGPACK_DEFINE(uid, suid, service, operation, lcn, session_key, data, raw_data);
};
using xiva_event_opt = boost::optional<xiva_event>;

}
