LIBRARY()
OWNER(g:xeno)

NO_UTIL()

CFLAGS(
    "-DBOOST_SPIRIT_THREADSAFE"
)

ADDINCL(
    # ya.make for libopendkim doesn't provide include directories >_<
    contrib/libs/libopendkim
    mail/xeno/src
)

PEERDIR(
    contrib/deprecated/jsoncpp
    contrib/restricted/boost
    contrib/restricted/boost/crc
    contrib/libs/msgpack
    contrib/libs/libopendkim
    contrib/libs/jwt-cpp
    mail/blowfish
    mail/contrib/histogram
    mail/ymod_httpclient
    mail/ymod_imapclient
    mail/ymod_lease
    mail/ymod_macs
    mail/ymod_statserver
    mail/ymod_metricserver
    mail/ymod_smtpclient
    mail/ymod_ratecontroller
    mail/ymod_tvm
    mail/ymod_webserver
    mail/ymod_mdb_sharder
    mail/ymod_cachedb
    mail/yplatform/lib
    mail/macs_pg
    mail/user_journal
)

SRCS(
    auth/revoke_token.cc
    mailbox/data_types/cache_mailbox.cc
    mailbox/data_types/folder.cc
    mailbox/data_types/flags.cc
    mailbox/data_types/message.cc
    mailbox/external/external_mailbox_impl.cc
    mailbox/external/get_folders.cc
    mailbox/local/sendbernar_client.cc
    common/account.cc
    common/base32.cc
    common/errors.cc
    common/gzip.cc
    common/http.cc
    common/json.cc
    mdb/errors.cc
    mdb/users_polling.cc
    typed_log/typed_log.cc
    web/errors.cc
    web/internal/load_user.cc
    web/internal/process_passport_events.cc
    web/internal/cache_dump.cc
    web/internal/response.cc
    web/mobile/response.cc
    web/mobile/auth_by_oauth.cc
    web/mobile/common.cc
    web/mobile/delete_items.cc
    web/mobile/ping.cc
    web/mobile/push.cc
    web/mobile/set_spam_status.cc
    web/mobile/auth_by_password.cc
    web/mobile/create_folder.cc
    web/mobile/send.cc
    web/mobile/store.cc
    web/mobile/default_method.cc
    web/mobile/messages.cc
    web/mobile/provider.cc
    web/mobile/set_label.cc
    web/mobile/update_folder.cc
    web/mobile/clear_folder.cc
    web/mobile/delete_folder.cc
    web/mobile/move_items.cc
    web/mobile/set_read_flag.cc
    web/mops/responses.cc
    web/sendbernar/responses.cc
    web/resolver.cc

    GLOBAL encryption/module.cc
    GLOBAL xeno/xeno_impl.cc
    GLOBAL xeno/xeno_impl_testing.cc
    GLOBAL web/impl.cc
)

END()
