#!/bin/bash

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/access.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xivaconf-access-log	timestamp=.{11}(\d\d:\d\d:\d\d)' $LOGFILE | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /request=/ {
        arr["http.total"]++
        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                collect_codes(substr($i, 13), "http.codes.total", arr)
            } else if ($i ~ /^profiler_exec=/) {
                collect_timings(substr($i, 15), "http.timings.all", arr)
            }
        }
    }

    END {
        for (i in arr) {
            value = arr[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
'