#pragma once

#include "settings.h"
#include <ymod_xconf/xconf.h>
#include <ymod_webserver/server.h>
#include <yplatform/module.h>

namespace yxiva { namespace conf {

class server : public yplatform::module
{
public:
    server(const yplatform::ptree& conf);
    server(const settings& settings);

    void fini();

protected:
    void put_configuration(
        ymod_webserver::http::stream_ptr stream,
        const string& name,
        const string& owner,
        ymod_xconf::config_type type,
        const string& environment,
        const string& token,
        ymod_xconf::revision_t revision);

    void list_configurations(
        ymod_webserver::http::stream_ptr stream,
        ymod_xconf::config_type type,
        const string& environment,
        ymod_xconf::revision_t revision);

    void handle_put(
        ymod_webserver::http::stream_ptr stream,
        const ymod_xconf::error_code& ec,
        ymod_xconf::revision_t revision);

    void handle_list(
        ymod_webserver::http::stream_ptr stream,
        const ymod_xconf::error_code& ec,
        const ymod_xconf::conf_list_ptr& configurations);

private:
    settings settings_;
    ymod_xconf::xconf_ptr confdb_;
};

}}
