#pragma once

#include <ymod_xconf/config_environment.h>
#include <yxiva/core/tvm.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace conf {

struct settings
{
    string web_server = "web_server";
    string front_endpoint;
    string allowed_environment;
    tvm_checker_settings tvm;

    settings(const yplatform::ptree& conf)
    {
        web_server = conf.get("web_server", web_server);
        front_endpoint = conf.get<string>("front_endpoint");
        allowed_environment = conf.get<string>("allowed_environment");

        if (boost::algorithm::iequals(allowed_environment, "any"))
        {
            allowed_environment.clear();
        }
        else if (
            ymod_xconf::resolve_environment(allowed_environment) ==
            ymod_xconf::config_environment::UNKNOWN)
        {
            throw std::runtime_error("unknown environment");
        }
        if (auto tvm_conf = conf.get_child_optional("tvm"))
        {
            tvm.parse_ptree(*tvm_conf);
        }
    }
};

}}
