#pragma once

#include <yplatform/future/future.hpp>
#include <ymod_blackbox/auth.h>
#include <yxiva/core/user_info.h>
#include <yxiva/core/types.h>

namespace yxiva {

typedef ymod_blackbox::address address;
typedef ymod_blackbox::request auth_request_t;
typedef ymod_blackbox::response auth_response_t;
typedef yplatform::future::future<ymod_blackbox::response> auth_future_t;
typedef yplatform::future::promise<ymod_blackbox::response> auth_promise_t;
typedef yplatform::future::future<user_info> user_info_future_t;
typedef yplatform::future::promise<user_info> user_info_promise_t;

class authorizer
{
public:
    typedef yplatform::task_context_ptr task_context_ptr;

    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const string& login) = 0;
    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const service_user_id& suid) = 0;
    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const user_id& uid) = 0;
    virtual ~authorizer()
    {
    }
};

typedef shared_ptr<authorizer> authorizer_ptr;

class authorizer_blackbox
    : public authorizer
    , public enable_shared_from_this<authorizer_blackbox>
{
public:
    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const string& login);
    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const service_user_id& suid);
    virtual user_info_future_t authenticate(
        task_context_ptr ctx,
        const address& user_address,
        const user_id& uid);

private:
    virtual void auth_cb(
        task_context_ptr ctx,
        auth_future_t resp,
        user_info_promise_t result,
        time_traits::time_point start_time);
};

}
