#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/operation_result.h>
#include <string>

namespace yxiva { namespace callback_uri {

static const string SCHEME_MOBILE = "xivamob:";
static const string SCHEME_WEBPUSH = "webpush:";
static const string SCHEME_INACTIVE = "inactive:";
static const string SCHEME_APNS_QUEUE = "apnsqueue:";
static const string SCHEME_XIVA_WEBSOCKET = "xivaws:";

// Compose URI for mobile subscription
string mobile_uri(const string& app_name, const string& push_token);

// Detect mobile scheme in URI
bool is_mobile_uri(const string& uri);

// Parse xiva mobile URI.
// Pre-requires check scheme using is_mobile_uri().
operation::result parse_mobile_uri(const string& uri, string& app_name, string& push_token);

// Compose URI for webpush subscription
string webpush_uri(const string& urlencoded_subscription);

// Detect webpush scheme in URI
bool is_webpush_uri(const string& uri);

// Parse a subscription xiva webpush URI.
// Pre-requires check scheme using is_webpush_uri().
operation::result parse_webpush_uri(const string& uri, string& urlencoded_subscription);

// Parse origin+subscription from xiva webpush URI.
// Pre-requires check scheme using is_webpush_uri().
// Like the above but also parse origin from uri.
operation::result parse_webpush_uri(
    const string& uri,
    string& origin,
    string& urlencoded_subscription);

// Parse an origin from xiva webpush URI.
// Pre-requires check scheme using is_webpush_uri().
operation::result parse_webpush_uri_origin(const string& uri, string& origin);

bool is_active_uri(const string& uri);
string inactive_uri(const string& uri);

// Compose URI for apns queue subscription.
string apns_queue_uri(const string& service, const string& app_name, const string& device);

// Detect apns queue scheme in uri.
bool is_apns_queue_uri(const string& uri);

// Parse xiva apns queue URI.
// Pre-requires check scheme using is_apns_queue_uri().
operation::result parse_apns_queue_uri(
    const string& uri,
    string& service,
    string& app_name,
    string& device);

// [XIVA-1725] Functions to make, detect and extract xiva-server websocket uris.
string xiva_websocket_uri(const string& callback);
bool is_xiva_websocket_uri(const string& uri);
std::pair<operation::result, string> parse_xiva_websocket_uri(const string& uri);

}}
