#pragma once

#include <yxiva/core/types.h>
#include <unordered_set>

namespace yxiva {

struct blacklisted_feature
{
    std::unordered_set<string> blacklist;

    bool enabled_for(const string& value) const
    {
        return blacklist.find(value) == blacklist.end();
    }

    void load(const yplatform::ptree& conf, const string& key)
    {
        yplatform::read_ptree(blacklist, conf, key);
    }
};

struct whitelisted_feature
{
    std::unordered_set<string> whitelist;

    bool enabled_for(const string& value) const
    {
        return whitelist.find(value) != whitelist.end();
    }

    void load(const yplatform::ptree& conf, const string& key)
    {
        yplatform::read_ptree(whitelist, conf, key);
    }
};

}