#pragma once

#include <yxiva/core/operation_result.h>
#include <yxiva/core/filter/filter_set.h>
#include <yxiva/core/json.h>

namespace yxiva { namespace filter {

enum format_version
{
    VERSION1,
    VERSION2,
    ANY
};

/** Parses filter set from raw string representation
 *  Returns:
 *    {true, ""} -- parsed successfully
 *    {false, error_reason} -- an error occured while parsing
 */
operation::result parse(
    filter_set& dest,
    const std::string& raw_src,
    const format_version version = ANY);

inline operation::result parse_v1(filter_set& dest, const std::string& raw_src)
{
    return parse(dest, raw_src, format_version::VERSION1);
}

inline operation::result parse_v2(filter_set& dest, const std::string& raw_src)
{
    return parse(dest, raw_src, format_version::VERSION2);
}

template <typename Condition>
operation::result decode_condition(Condition& cond, const json_value& json_cond);

filter::action parse_and_apply(const sub_t& subscription, const message& message);

operation::result parse_and_apply(
    filter::action& action,
    const sub_t& subscription,
    const message& message);

}}
