#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/json/detail/decoder.h>

namespace yxiva {

template <typename Dest>
struct json_decoder
{
    static Dest get(const json_value& value, const Dest& def)
    {
        return detail::json_get_value<Dest>(value, def);
    }

    static Dest get(const json_value& obj, const char* key, const Dest& def)
    {
        if (obj.type() == json_type::tobject)
        {
            return detail::json_get_value<Dest>(obj[key], def);
        }
        return def;
    }
};

template <typename Dest>
Dest json_get(const json_value& value, const Dest& def)
{
    return json_decoder<Dest>::get(value, def);
}

template <typename Dest>
Dest json_get(const json_value& obj, const char* key, const Dest& def)
{
    return json_decoder<Dest>::get(obj, key, def);
}

}
