#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/json/include.h>
#include <type_traits>

namespace yxiva { namespace detail {

template <typename Dest>
typename std::enable_if<!std::is_integral<Dest>::value, Dest>::type json_get_value(
    const json_value& value,
    const Dest& def);

template <typename Dest>
typename std::enable_if<
    std::numeric_limits<Dest>::is_integer and std::numeric_limits<Dest>::is_signed,
    Dest>::type
json_get_value(const json_value& value, Dest def)
{
    switch (value.type())
    {
    case json_type::tnumber:
        return value.is_int64() ? static_cast<Dest>(value.to_int64()) : def;
    case json_type::tbool:
        return static_cast<Dest>(value.to_bool());
    default:
        return def;
    }
}

template <typename Dest>
typename std::enable_if<
    std::numeric_limits<Dest>::is_integer and not std::numeric_limits<Dest>::is_signed,
    Dest>::type
json_get_value(const json_value& value, Dest def)
{
    switch (value.type())
    {
    case json_type::tnumber:
        return value.is_uint64() ? static_cast<Dest>(value.to_uint64()) : def;
    case json_type::tbool:
        return static_cast<Dest>(value.to_bool());
    default:
        return def;
    }
}

template <>
inline json_value json_get_value<json_value>(const json_value& value, const json_value& def)
{
    switch (value.type())
    {
    case json_type::tobject:
    case json_type::tarray:
        return value;
    default:
        return def;
    }
}

}}
