#pragma once

#include <yxiva/core/json/include.h>

namespace yxiva {

inline bool is_null(const json_value& value)
{
    return value.type() == json_type::tnull;
}

inline bool is_null(const json_value& value, const std::string& key)
{
    return !value.has_member(key) || is_null(value[key]);
}

}