#pragma once

#include <map>
#include <string>

inline const std::string& find_map_value(
    const std::map<std::string, std::string>& map,
    const std::string& key)
{
    static const std::string EMPTY_VALUE = "";
    std::map<std::string, std::string>::const_iterator i_val = map.find(key);
    if (i_val == map.end()) return EMPTY_VALUE;
    return i_val->second;
}

inline const std::string find_all_map_values(
    const std::map<std::string, std::string>& map,
    const std::vector<std::string>& keys,
    const std::string& separator = ",")
{
    if (keys.empty()) return "";

    std::ostringstream out;
    bool is_first = true;
    std::vector<std::string>::const_iterator key;
    for (key = keys.begin(); key != keys.end(); ++key)
    {
        if (!is_first) out << separator << " ";
        else
            is_first = false;

        out << *key << "=\"";
        auto pair = map.find(*key);
        if (pair != map.end()) out << pair->second;
        out << "\"";
    }
    return out.str();
}
