#pragma once

#include <yxiva/core/types.h>
#include <ymod_webserver/handler.h>

namespace yxiva {

using ymod_webserver::request_ptr;
using ymod_webserver::response_ptr;
using ymod_webserver::http_uri;

class request_adaptor
{
public:
    request_adaptor(request_ptr req, response_ptr res);

    task_context_ptr ctx()
    {
        return req_->context;
    }

    http_uri const& uri()
    {
        return req_->url;
    }

    void set_code(ymod_webserver::codes::code code);

    void add_header(const string& name, const string& value);

    void send_result(string const& message);

    void send_error(
        ymod_webserver::codes::code code,
        string const& message,
        string const& verbose = "");

    string extract_param(string const& name)
    {
        return req_->url.param_value(name);
    }

    string const& extract_header(string const& name, string const& def = "")
    {
        ymod_webserver::header_map_t::const_iterator found = req_->headers.find(name);
        return found != req_->headers.end() ? found->second : def;
    }

    request_ptr native_request()
    {
        return req_;
    }

    response_ptr native_response()
    {
        return res_;
    }

private:
    request_ptr req_;
    response_ptr res_;
    bool code_sent_;
};

typedef shared_ptr<request_adaptor> request_adaptor_ptr;

}