#pragma once

#include <iostream>
#include <vector>

#include <yxiva/core/types.h>

namespace yxiva {

class nested_prefix_stream
{
public:
    nested_prefix_stream(std::ostream& impl);
    void push(string const& prefix, bool add_space = true);
    void push_not_empty(
        string const& prefix,
        string const& placeholder = "-",
        bool add_space = true);
    void pop();

    template <typename T>
    std::ostream& operator<<(T const& value);

private:
    nested_prefix_stream(nested_prefix_stream const&);
    nested_prefix_stream& operator=(nested_prefix_stream const&);

    void rebuild_prefix();
    string prefix_;
    std::vector<string> prefix_items_;
    std::ostream& impl_;
};

template <typename T>
std::ostream& nested_prefix_stream::operator<<(T const& value)
{
    impl_ << prefix_ << value;
    return impl_;
}

}
