#pragma once

#include <yxiva/core/types.h>
#include <msgpack/type.hpp>

namespace yxiva {

struct notify_status
{
    size_t seq = 0;
    int code = -1;
    string body;
    string subscription_id;

    notify_status()
    {
    }

    notify_status(int code, string body) : code(code), body(body)
    {
    }

    MSGPACK_DEFINE(seq, code, body, subscription_id);
};

}
