#pragma once

#include <string>
#include <iostream>

namespace yxiva { namespace operation {

using std::string;

struct result
{
    string error_reason;

    result() = default;

    result(const string& error) : error_reason(error)
    {
    }

    result(string&& error) : error_reason(std::move(error))
    {
    }

    result(const char* error) : error_reason(error)
    {
    }

    bool success() const
    {
        return error_reason.empty();
    }

    operator bool() const
    {
        return success();
    }
};

static const result success;

class error
{
public:
    error()
    {
    }

    error(const char* error) : impl(error)
    {
    }

    error(const string& error) : impl(error)
    {
    }

    error(string&& error) : impl(std::move(error))
    {
    }

    error& operator=(const char* error)
    {
        impl = error;
        return *this;
    }

    error& operator=(const string& error)
    {
        impl = error;
        return *this;
    }

    error& operator=(string&& error)
    {
        impl = std::move(error);
        return *this;
    }

    operator const string&() const
    {
        return impl;
    }

    operator bool() const
    {
        return impl.size();
    }

private:
    string impl;
};

}}
