#pragma once

#include <yxiva/core/platforms.h>
#include <yxiva/core/subscriptions.h>
#include <string>
#include <msgpack.hpp>

namespace yxiva {

template <typename T>
inline std::string pack(const T& message)
{
    msgpack::sbuffer sbuf;
    msgpack::pack(sbuf, message);
    return std::string(sbuf.data(), sbuf.data() + sbuf.size());
}

template <typename T>
inline void pack(const T& message, string& out)
{
    msgpack::sbuffer sbuf;
    msgpack::pack(sbuf, message);
    out.append(sbuf.data(), sbuf.data() + sbuf.size());
}

template <>
inline std::string pack(const sub_t& sub)
{
    auto copy = sub;
    copy.platform = platform::hacks::fcm_to_gcm(copy.platform); // gcm_compatibility
    msgpack::sbuffer sbuf;
    msgpack::pack(sbuf, copy);
    return std::string(sbuf.data(), sbuf.data() + sbuf.size());
}

template <typename T>
inline void unpack(const char* data, size_t size, T& message)
{
#if MSGPACK_VERSION_MAJOR == 0
    msgpack::unpacked unpacked_msg;
    msgpack::unpack(&unpacked_msg, data, size);
    unpacked_msg.get().convert(&message);
#else
    msgpack::unpacked unpacked_msg = msgpack::unpack(data, size);
    unpacked_msg.get().convert(message);
#endif
}

template <typename T>
inline void unpack(const std::string& source, T& message)
{
    unpack(source.data(), source.size(), message);
}

template <>
inline void unpack(const std::string& source, sub_t& sub)
{
#if MSGPACK_VERSION_MAJOR == 0
    msgpack::unpacked unpacked_msg;
    msgpack::unpack(&unpacked_msg, source.data(), source.size());
    unpacked_msg.get().convert(&sub);
#else
    msgpack::unpacked unpacked_msg = msgpack::unpack(source.data(), source.size());
    unpacked_msg.get().convert(sub);
#endif
    sub.platform = platform::resolve_alias(sub.platform).name; // gcm_compatibility
}

}
