#pragma once

#include <yxiva/core/conf.h>
#include <yxiva/core/json.h>
#include <yxiva/core/x509.h>
#include <yxiva/core/operation_result.h>

namespace yxiva {

namespace platform {
static const std::string APNS = "apns";
}

namespace apns {

enum class certificate_type
{
    development,
    production
};

certificate_type certificate_type_from_env(app_environment env);
certificate_type resolve_certificate_type(const string& name);
const string& get_certificate_type_name(certificate_type type);

struct p8_token
{
    p8_token() = default;
    explicit p8_token(const json_value& json);
    explicit p8_token(const string& secret);
    p8_token(
        const string& key,
        const string& key_id,
        const string& issuer_key,
        const string& topic,
        const string& type);

    json_value to_json() const;
    string to_string() const;

    string key;
    string key_id;
    string issuer_key;
    string topic;
    string type;
};

namespace pem_certificate {

string from_p12(const string& p12_cert, const string& password);
bool contains_pem(const string& cert);
void validate(const string& cert);
int64_t get_expiration_time(const string& cert);
string get_topic(const string& cert);
certificate_type get_type(const string& cert);

}

// We know that the unique part of transit id is at the
// beginning, therefore we can truncate it to fit
// collapse-id size without loosing uniqueness.
inline auto collapse_id_from_transit_id(const string& transit_id)
{
    static const std::size_t MAX_COLLAPSE_ID_SIZE = 64;
    return transit_id.substr(0, MAX_COLLAPSE_ID_SIZE);
}

}
}
