#pragma once

#include <string>

namespace yxiva {

namespace platform {
static const std::string FCM = "fcm";

namespace hacks {
inline const std::string& fcm_to_gcm(const std::string& name) // gcm_compatibility
{
    static const std::string GCM = "gcm"; // gcm_compatibility
    return name == FCM ? GCM : name;      // gcm_compatibility
}
}
}

static const string FCM_TOPIC_PREFIX = "/topics/";

inline bool is_fcm_topic(const string& push_token)
{
    return push_token.compare(0, FCM_TOPIC_PREFIX.size(), FCM_TOPIC_PREFIX) == 0;
}

namespace fcm {

struct credential
{
    string api_key;

    auto to_secret_key() const
    {
        return api_key;
    }
};

inline auto parse_secret_key(const string& secret_key)
{
    credential result;
    result.api_key = secret_key.substr(0, secret_key.find('\n'));
    return result;
}

}
}
