#pragma once

#include <yplatform/util/sstream.h>

namespace yxiva {

namespace platform {
static const std::string HMS = "hms";
}

namespace hms {

struct credential
{
    string id;
    string secret;

    auto to_secret_key() const
    {
        string result;
        yplatform::sstream(result, id.size() + secret.size() + 1) << id << "\n" << secret;
        return result;
    }
};

inline auto parse_secret_key(const string& secret_key)
{
    credential result;
    std::stringstream ss(secret_key);
    std::getline(ss, result.id);
    std::getline(ss, result.secret);
    return result;
}

}
}
