#pragma once

#include <yplatform/util/sstream.h>

namespace yxiva {

namespace platform {
static const std::string WNS = "wns";
}

namespace wns {

struct credential
{
    string sid;
    string secret;

    auto to_secret_key() const
    {
        string result;
        yplatform::sstream(result, sid.size() + secret.size() + 1) << sid << "\n" << secret;
        return result;
    }
};

inline auto parse_secret_key(const string& secret_key)
{
    credential result;
    std::stringstream ss(secret_key);
    std::getline(ss, result.sid);
    std::getline(ss, result.secret);
    return result;
}

}
}
