#pragma once

#include <ctime>

/**
 * copy-pasted from ymod_webserver
 */
namespace yxiva {

namespace {
const char* month_names[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                              "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
const char* day_names[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
}

template <typename Stream>
void print_date(Stream& out, std::time_t date)
{
    // Thu, 31 Mar 2011 10:38:15 GMT
    std::tm gmt_date;
    ::gmtime_r(&date, &gmt_date);
    out << day_names[gmt_date.tm_wday] << ", " << gmt_date.tm_mday << " "
        << month_names[gmt_date.tm_mon] << " " << gmt_date.tm_year + 1900 << " " << std::setw(2)
        << std::setfill('0') << gmt_date.tm_hour << ":" << std::setw(2) << std::setfill('0')
        << gmt_date.tm_min << ":" << std::setw(2) << std::setfill('0') << gmt_date.tm_sec << " GMT";
}

}
