#pragma once

#include <yplatform/range.h>
#include <yplatform/util/sstream.h>
#include <boost/range/iterator_range.hpp>
#include <string>

namespace yxiva { namespace formatters {

using std::string;
#define PRINT_TO_OUT_STREAM(str) out << boost::make_iterator_range(i_data, i) << str

template <typename Iterator, typename Stream>
void quoteXML(const Iterator& begin, const Iterator& end, Stream& out)
{
    Iterator i_data = begin;
    for (Iterator i = begin, i_end = end; i != i_end; ++i)
    {
        switch (*i)
        {
        case '&':
            PRINT_TO_OUT_STREAM("&amp;");
            break;
        case '<':
            PRINT_TO_OUT_STREAM("&lt;");
            break;
        case '>':
            PRINT_TO_OUT_STREAM("&gt;");
            break;
        case '\"':
            PRINT_TO_OUT_STREAM("&quot;");
            break;
        case '\'':
            PRINT_TO_OUT_STREAM("&apos;");
            break;
        default:
            continue;
        }
        i_data = i;
        ++i_data;
    }
    out << boost::make_iterator_range(i_data, end);
}

template <typename Stream>
void quoteXML(const string& data, Stream& out)
{
    quoteXML(data.begin(), data.end(), out);
}

template <typename Stream>
void quoteXML(const string_view& data, Stream& out)
{
    quoteXML(data.begin(), data.end(), out);
}

template <typename Stream>
void quoteXML(const char* data, Stream& out)
{
    quoteXML(data, data + std::char_traits<char>::length(data), out);
}

template <typename T>
struct quoteXML_wrapper
{
    quoteXML_wrapper(const T& s) : data(s)
    {
    }
    const T& data;
};

template <typename T>
inline quoteXML_wrapper<T> quoteXML(const T& data)
{
    return quoteXML_wrapper<T>(data);
}

template <typename T>
inline std::string& operator+=(std::string& s, const quoteXML_wrapper<T>& q)
{
    yplatform::sstream out(s);
    formatters::quoteXML(q.data, out);
    return s;
}

#undef PRINT_TO_OUT_STREAM

}}
