#pragma once

#include <yxiva/core/types.h>

namespace yxiva {

inline string read_text_file(const string& path)
{
    std::stringbuf buf;
    {
        std::ostream stream(&buf);
        std::ifstream rf(path.c_str());
        if (!rf.is_open() || !rf.good())
            throw std::runtime_error("can`t load text file '" + path + "'");
        rf >> std::noskipws;
        std::copy(
            std::istream_iterator<char>(rf),
            std::istream_iterator<char>(),
            std::ostream_iterator<char>(stream));
    }
    return buf.str();
}

}
