#pragma once

#include <yxiva/core/types.h>
#include <yplatform/util/per_second_accumulator.h>
#include <yplatform/module.h>

namespace yxiva {

class request_stats
{
public:
    typedef yplatform::per_second_accumulator<int> accumulator_t;

    request_stats() : total_(61), accepted_(61)
    {
    }

    accumulator_t::value_type new_request()
    {
        return total_.add(1);
    }

    void accept_request()
    {
        accepted_.add(1);
    }

    yplatform::ptree to_ptree() const
    {
        yplatform::ptree result;

        auto total_sec = total_.get_last();
        auto accepted_sec = accepted_.get_last();
        auto rejected_sec = total_sec - accepted_sec;
        auto rejected_percent =
            static_cast<int>(total_sec ? static_cast<double>(rejected_sec) / total_sec * 100.0 : 0);
        auto sum_total = total_.get_sum(60);
        auto sum_accepted = accepted_.get_sum(60);
        auto sum_rejected = sum_total - sum_accepted;
        auto sum_rejected_percent =
            static_cast<int>(sum_total ? static_cast<double>(sum_rejected) / sum_total * 100.0 : 0);

        result.put("rps", boost::lexical_cast<string>(total_sec));
        result.put("rejected", boost::lexical_cast<string>(rejected_sec));
        result.put("rejected_percent", boost::lexical_cast<string>(rejected_percent));
        result.put("minute_sum_rps", boost::lexical_cast<string>(sum_total));
        result.put("minute_sum_rejected", boost::lexical_cast<string>(sum_rejected));
        result.put(
            "minute_sum_rejected_percent", boost::lexical_cast<string>(sum_rejected_percent));

        return result;
    }

private:
    mutable accumulator_t total_;
    mutable accumulator_t accepted_;
};

}
